/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.syncing.ui.wizards;

import com.aptana.core.logging.IdeLog;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.syncing.ui.SyncingUIPlugin;
import com.aptana.syncing.ui.wizards.ExportConnectionsPage;
import com.aptana.syncing.ui.wizards.Messages;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.osgi.service.prefs.BackingStoreException;

public class ExportConnectionsWizard
extends Wizard
implements IExportWizard {
    private ExportConnectionsPage mainPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.mainPage = new ExportConnectionsPage();
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        IPath path = this.mainPage.getLocation();
        boolean isOverwriting = this.mainPage.isOverwritingExistingFile();
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.syncing.ui");
        prefs.put("EXPORT_INITIAL_PATH", path.toOSString());
        prefs.putBoolean("OVEWRITE_FILE_WITHOUT_WARNING", isOverwriting);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)SyncingUIPlugin.getDefault(), (String)Messages.ExportConnectionsWizard_ERR_FailSaveExportPrefs, (Throwable)e);
        }
        File file = path.toFile();
        if (file.exists()) {
            if (!isOverwriting && !MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.ExportConnectionsWizard_Overwrite_Title, (String)MessageFormat.format(Messages.ExportConnectionsWizard_Overwrite_Message, file.getAbsolutePath()))) {
                return false;
            }
            if (!file.canWrite()) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ExportConnectionsWizard_Error_Title, (String)MessageFormat.format(Messages.ExportConnectionsWizard_Error_Message, file.getAbsolutePath()));
                return false;
            }
        }
        CoreIOPlugin.getConnectionPointManager().saveState(path);
        return true;
    }
}

